
//  (C) Copyright Edward Diener 2011-2015
//  Use, modification and distribution are subject to the Boost Software License,
//  Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
//  http://www.boost.org/LICENSE_1_0.txt).

#include <boost/vmd/elem.hpp>
#include <boost/vmd/equal.hpp>
#include <boost/vmd/is_identifier.hpp>
#include <boost/detail/lightweight_test.hpp>

int main()
  {
  
#if BOOST_PP_VARIADICS
 
 #define BOOST_VMD_REGISTER_yellow (yellow)
 #define BOOST_VMD_REGISTER_green (green)
 #define BOOST_VMD_REGISTER_blue (blue)
 #define BOOST_VMD_REGISTER_red (red)
 
 #define BOOST_VMD_DETECT_yellow_yellow
 #define BOOST_VMD_DETECT_green_green
 #define BOOST_VMD_DETECT_blue_blue
 
 BOOST_TEST(BOOST_VMD_IS_IDENTIFIER(yellow,yellow));
 BOOST_TEST(!BOOST_VMD_IS_IDENTIFIER(green,yellow));
 BOOST_TEST(!BOOST_VMD_IS_IDENTIFIER(blue,yellow));
 BOOST_TEST(!BOOST_VMD_IS_IDENTIFIER(red,yellow));
 
 BOOST_TEST(BOOST_VMD_IS_IDENTIFIER(yellow,yellow,blue));
 BOOST_TEST(BOOST_VMD_IS_IDENTIFIER(blue,yellow,blue));
 BOOST_TEST(!BOOST_VMD_IS_IDENTIFIER(green,yellow,blue));
 BOOST_TEST(!BOOST_VMD_IS_IDENTIFIER(red,yellow,blue));
 
 BOOST_TEST(BOOST_VMD_IS_IDENTIFIER(yellow,(yellow,green)));
 BOOST_TEST(BOOST_VMD_IS_IDENTIFIER(green,(yellow,green)));
 BOOST_TEST(!BOOST_VMD_IS_IDENTIFIER(blue,(yellow,green)));
 BOOST_TEST(!BOOST_VMD_IS_IDENTIFIER(red,(yellow,green)));
 
 BOOST_TEST(!BOOST_VMD_IS_IDENTIFIER(red,red));
 BOOST_TEST(BOOST_VMD_IS_IDENTIFIER(red));
 
 #define BOOST_VMD_REGISTER_ANAME (ANAME)
 #define BOOST_VMD_REGISTER_APLACE (APLACE)
 #define BOOST_VMD_REGISTER_ACOUNTRY (ACOUNTRY)
 
 #define BOOST_VMD_DETECT_ANAME_ANAME
 #define BOOST_VMD_DETECT_APLACE_APLACE
 
 #define A_SEQUENCE (1,2,3) ANAME 46 BOOST_VMD_TYPE_SEQ ACOUNTRY

 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(1,A_SEQUENCE),ANAME));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(1,A_SEQUENCE,BOOST_VMD_TYPE_IDENTIFIER),ANAME));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(1,A_SEQUENCE,BOOST_VMD_TYPE_IDENTIFIER,APLACE,ACOUNTRY),));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(1,A_SEQUENCE,BOOST_VMD_TYPE_IDENTIFIER,ANAME,APLACE,ACOUNTRY),ANAME));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(1,A_SEQUENCE,BOOST_VMD_TYPE_IDENTIFIER,(APLACE,ACOUNTRY,ANAME)),ANAME));
 
 BOOST_TEST(BOOST_VMD_IS_IDENTIFIER(BOOST_VMD_ELEM(4,A_SEQUENCE)));
 BOOST_TEST(BOOST_VMD_IS_IDENTIFIER(BOOST_VMD_ELEM(4,A_SEQUENCE,BOOST_VMD_TYPE_IDENTIFIER)));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(4,A_SEQUENCE,BOOST_VMD_TYPE_IDENTIFIER,ACOUNTRY,ANAME),));
 
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(3,A_SEQUENCE),BOOST_VMD_TYPE_SEQ));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(3,A_SEQUENCE,BOOST_VMD_TYPE_IDENTIFIER),BOOST_VMD_TYPE_SEQ));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(3,A_SEQUENCE,BOOST_VMD_TYPE_IDENTIFIER,BOOST_VMD_TYPE_SEQ,BOOST_VMD_TYPE_TUPLE),));
 
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(3,A_SEQUENCE,BOOST_VMD_TYPE_IDENTIFIER,(BOOST_VMD_TYPE_SEQ,BOOST_VMD_TYPE_TUPLE)),BOOST_VMD_TYPE_SEQ));
 
#else

BOOST_ERROR("No variadic macro support");
  
#endif

  return boost::report_errors();
  
  }
